﻿/*
Run this script on:

4_2_0_Core    -  This database will be modified

to upgrade it to:

5_0_0_Core

You are recommended to back up your database before running this script.

*/
		
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO
BEGIN TRANSACTION
-- Pointer used for text / image updates. This might not be needed, but is declared here just in case
DECLARE @pv binary(16)

PRINT(N'Drop constraint FK_MonitorTabMessage_LogMessage from [hips].[MonitorTabMessage]')
ALTER TABLE [hips].[MonitorTabMessage] DROP CONSTRAINT [FK_MonitorTabMessage_LogMessage]

PRINT(N'Drop constraints from [hips].[DocumentFormat]')
ALTER TABLE [hips].[DocumentFormat] DROP CONSTRAINT [FK_DocumentFormat_CodeSystem]

PRINT(N'Update rows in [hips].[ModeOfSeparation]')
UPDATE [hips].[ModeOfSeparation] SET [Description]='Acute Hospital' WHERE [ModeOfSeparationId] = 1
UPDATE [hips].[ModeOfSeparation] SET [Description]='Other Health Service' WHERE [ModeOfSeparationId] = 4
UPDATE [hips].[ModeOfSeparation] SET [Description]='Self Discharge' WHERE [ModeOfSeparationId] = 6
UPDATE [hips].[ModeOfSeparation] SET [Description]='Home' WHERE [ModeOfSeparationId] = 9
PRINT(N'Operation applied to 4 rows out of 10')

PRINT(N'Update rows in [hips].[LogMessage]')
UPDATE [hips].[LogMessage] SET [Description]='Error while getting AD groups with Local security' WHERE [LogMessageId] = 1029
UPDATE [hips].[LogMessage] SET [Description]='Error while getting AD groups with Active Directory security' WHERE [LogMessageId] = 1030
PRINT(N'Operation applied to 2 rows out of 2')

PRINT(N'Add rows to [hips].[DocumentFormat]')
SET IDENTITY_INSERT [hips].[DocumentFormat] ON
IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.23')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (46, '1.2.36.1.2001.1006.1.16615.23', 'PCEHR R5 - Specialist Letter - Conformance 1A - HPI-I relaxed', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.24')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (47, '1.2.36.1.2001.1006.1.16615.24', 'PCEHR R5 - Specialist Letter - Conformance 1B - HPI-I relaxed', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.25')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (48, '1.2.36.1.2001.1006.1.16615.25', 'PCEHR R5 - Specialist Letter - Conformance 2 - HPI-I relaxed', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.26')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (49, '1.2.36.1.2001.1006.1.16615.26', 'PCEHR R5 - Specialist Letter - Conformance 3A - HPI-I relaxed', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.27')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (50, '1.2.36.1.2001.1006.1.16615.27', 'PCEHR R5 - Specialist Letter - Conformance 3B - HPI-I relaxed', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.28')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (51, '1.2.36.1.2001.1006.1.16615.28', 'PCEHR R5 - Specialist Letter - Conformance 1A - HPI-I enforced', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.29')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (52, '1.2.36.1.2001.1006.1.16615.29', 'PCEHR R5 - Specialist Letter - Conformance 1B - HPI-I enforced', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.30')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (53, '1.2.36.1.2001.1006.1.16615.30', 'PCEHR R5 - Specialist Letter - Conformance 2 - HPI-I enforced', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.31')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (54, '1.2.36.1.2001.1006.1.16615.31', 'PCEHR R5 - Specialist Letter - Conformance 3A - HPI-I enforced', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT [DocumentFormatId] FROM [hips].[DocumentFormat] WHERE Code='1.2.36.1.2001.1006.1.16615.32')
INSERT INTO [hips].[DocumentFormat] ([DocumentFormatId], [Code], [Description], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (55, '1.2.36.1.2001.1006.1.16615.32', 'PCEHR R5 - Specialist Letter - Conformance 3B - HPI-I enforced', 105, '2015-02-23 00:00:00.000', 'HIPS', '2015-02-23 00:00:00.000', 'HIPS')

SET IDENTITY_INSERT [hips].[DocumentFormat] OFF
PRINT(N'Operation applied to 10 rows out of 10')

PRINT(N'Add constraint FK_MonitorTabMessage_LogMessage to [hips].[MonitorTabMessage]')
ALTER TABLE [hips].[MonitorTabMessage] WITH CHECK  ADD CONSTRAINT [FK_MonitorTabMessage_LogMessage] FOREIGN KEY ([LogMessageId]) REFERENCES [hips].[LogMessage] ([LogMessageId])

PRINT(N'Add constraints to [hips].[DocumentFormat]')
ALTER TABLE [hips].[DocumentFormat] WITH CHECK  ADD CONSTRAINT [FK_DocumentFormat_CodeSystem] FOREIGN KEY ([CodeSystemId]) REFERENCES [hips].[CodeSystem] ([CodeSystemId])
COMMIT TRANSACTION
GO
